/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.services;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.services.LoaderService;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.ItemInPipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1058;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import org.apache.commons.lang3.function.TriFunction;

public class FabricService
implements LoaderService {
    @Override
    public <B extends class_2586> class_2591<B> createBlockEntityType(BiFunction<class_2338, class_2680, B> blockEntitySupplier, class_2248 ... validBlocks) {
        return class_2591.class_2592.method_20528(blockEntitySupplier::apply, (class_2248[])validBlocks).method_11034(null);
    }

    @Override
    public <M extends class_1703, D> class_3917<M> createMenuType(TriFunction<Integer, class_1661, D, M> menuSupplier, SelfHandler<D> handler) {
        return new ExtendedScreenHandlerType((id, inventory, buffer) -> (class_1703)menuSupplier.apply((Object)id, (Object)inventory, handler.decode(buffer)));
    }

    @Override
    public <M extends class_1703> class_3917<M> createSimpleMenuType(BiFunction<Integer, class_1661, M> menuSupplier) {
        return new class_3917(menuSupplier::apply, class_7701.field_40183);
    }

    @Override
    public <D> void openMenu(class_3222 player, final class_3908 menuProvider, final D payload, final SelfHandler<D> handler) {
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buffer) {
                handler.encode(payload, buffer);
            }

            public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                return menuProvider.createMenu(id, inventory, player);
            }

            public class_2561 method_5476() {
                return menuProvider.method_5476();
            }
        });
    }

    @Override
    public boolean canAccessContainer(class_1937 level, class_2338 containerPos, class_2350 face) {
        class_2680 state = level.method_8320(containerPos);
        if (state.method_26204() instanceof PipeBlock) {
            return false;
        }
        Storage itemHandler = (Storage)ItemStorage.SIDED.find(level, containerPos, (Object)face);
        if (itemHandler != null) {
            return itemHandler.supportsExtraction() || itemHandler.supportsInsertion();
        }
        return false;
    }

    @Override
    public <T extends PayloadWrapper<T>> void sendToServer(T payload) {
        ClientPlayNetworking.send((class_2960)payload.getType(), (class_2540)payload.getHandler().encode(payload, PacketByteBufs.create()));
    }

    @Override
    public <T extends PayloadWrapper<T>> void sendToClient(class_3222 player, T payload) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)payload.getType(), (class_2540)payload.getHandler().encode(payload, PacketByteBufs.create()));
    }

    @Override
    public boolean handleItemInsertion(ItemPipeEntity pipe, class_3218 level, class_2338 pipePos, class_2680 pipeState, ItemInPipe item) {
        class_2338 containerPos = pipePos.method_10093(item.getTargetDirection());
        class_2586 blockEntity = level.method_8321(containerPos);
        if (blockEntity instanceof ItemPipeEntity) {
            ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
            item.resetProgress(item.getTargetDirection().method_10153());
            nextPipe.insertPipeItem((class_1937)level, item);
            level.method_8413(containerPos, nextPipe.method_11010(), nextPipe.method_11010(), 2);
            return true;
        }
        class_2350 face = item.getTargetDirection().method_10153();
        Storage itemHandler = (Storage)ItemStorage.SIDED.find((class_1937)level, containerPos, (Object)face);
        if (itemHandler != null) {
            int inserted;
            int count = item.getStack().method_7947();
            try (Transaction transaction = Transaction.openOuter();){
                inserted = (int)itemHandler.insert((Object)ItemVariant.of((class_1799)item.getStack()), (long)count, (TransactionContext)transaction);
                transaction.commit();
            }
            if (inserted >= count) {
                return true;
            }
            item.setStack(item.getStack().method_46651(count - inserted));
        }
        item.resetProgress(item.getTargetDirection());
        pipe.routeItem(pipeState, item);
        return false;
    }

    @Override
    public boolean handleItemExtraction(ItemPipeEntity pipe, class_2680 pipeState, class_3218 level, class_2338 containerPos, class_2350 face, int amount, Predicate<class_1799> predicate) {
        class_2680 state = level.method_8320(containerPos);
        if (state.method_26204() instanceof PipeBlock) {
            return false;
        }
        Storage itemHandler = (Storage)ItemStorage.SIDED.find((class_1937)level, containerPos, (Object)face);
        if (itemHandler != null) {
            ArrayList itemViewList = new ArrayList();
            itemHandler.nonEmptyIterator().forEachRemaining(itemViewList::add);
            class_1799 stack = class_1799.field_8037;
            try (Transaction transaction = Transaction.openOuter();){
                for (int i = itemViewList.size() - 1; i >= 0; --i) {
                    int extracted;
                    StorageView itemView = (StorageView)itemViewList.get(i);
                    ItemVariant resource = (ItemVariant)itemView.getResource();
                    if (!predicate.test(resource.toStack()) || (extracted = (int)itemView.extract((Object)resource, (long)amount, (TransactionContext)transaction)) <= 0) continue;
                    stack = resource.toStack(extracted);
                    transaction.commit();
                    break;
                }
            }
            if (!stack.method_7960()) {
                pipe.setItem(face.method_10153(), stack);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<class_1799> getContainerItems(class_3218 level, class_2338 pos, class_2350 face) {
        Storage itemHandler = (Storage)ItemStorage.SIDED.find((class_1937)level, pos, (Object)face);
        if (itemHandler != null) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            Iterator iterator = itemHandler.nonEmptyIterator();
            while (iterator.hasNext()) {
                StorageView itemView = (StorageView)iterator.next();
                boolean matched = false;
                for (class_1799 stack : stacks) {
                    if (!((ItemVariant)itemView.getResource()).matches(stack)) continue;
                    stack.method_7939(stack.method_7947() + (int)itemView.getAmount());
                    matched = true;
                    break;
                }
                if (matched) continue;
                stacks.add(((ItemVariant)itemView.getResource()).toStack((int)itemView.getAmount()));
            }
            return stacks;
        }
        return List.of();
    }

    @Override
    public boolean extractSpecificItem(ItemPipeEntity pipe, class_3218 level, class_2338 containerPos, class_2350 face, class_1799 stack) {
        Storage itemHandler = (Storage)ItemStorage.SIDED.find((class_1937)level, containerPos, (Object)face);
        boolean success = false;
        if (itemHandler != null) {
            try (Transaction transaction = Transaction.openOuter();){
                int extracted = (int)itemHandler.extract((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                if (extracted == stack.method_7947()) {
                    int removed;
                    success = true;
                    transaction.commit();
                    for (int itemsLeft = extracted; itemsLeft > 0; itemsLeft -= removed) {
                        removed = Math.min(stack.method_7914(), itemsLeft);
                        pipe.setItem(face.method_10153(), stack.method_46651(removed));
                    }
                } else {
                    transaction.abort();
                }
            }
        }
        return success;
    }

    @Override
    public String getModName(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modId);
    }

    @Override
    public boolean handleFluidInsertion(FluidPipeEntity pipe, class_3218 level, class_2338 pipePos, class_2680 pipeState, class_2586 containerEntity, class_2338 containerPos, class_3611 fluid, FluidInPipe fluidPacket) {
        class_2350 face = fluidPacket.getTargetDirection().method_10153();
        Storage fluidHandler = (Storage)FluidStorage.SIDED.find((class_1937)level, containerPos, containerEntity.method_11010(), containerEntity, (Object)face);
        if (fluidHandler != null && fluidHandler.supportsInsertion()) {
            long inserted = 0L;
            long amount = (long)fluidPacket.getAmount() * 81L;
            try (Transaction transaction = Transaction.openOuter();){
                FluidVariant fluidVariant = FluidVariant.of((class_3611)fluid);
                if (!fluidVariant.isBlank()) {
                    inserted = fluidHandler.insert((Object)FluidVariant.of((class_3611)fluid), amount, (TransactionContext)transaction);
                    transaction.commit();
                }
            }
            if (inserted >= amount) {
                return true;
            }
            fluidPacket.setAmount((int)((amount - inserted) / 81L));
        }
        return false;
    }

    @Override
    public boolean canAccessFluidContainer(class_1937 level, class_2338 containerPos, class_2350 face) {
        class_2680 state = level.method_8320(containerPos);
        if (state.method_26204() instanceof FluidPipeBlock) {
            return false;
        }
        Storage fluidHandler = (Storage)FluidStorage.SIDED.find(level, containerPos, (Object)face);
        if (fluidHandler != null) {
            return fluidHandler.supportsExtraction() || fluidHandler.supportsInsertion();
        }
        return false;
    }

    @Override
    public boolean handleFluidExtraction(FluidPipeEntity pipe, class_2680 pipeState, class_3218 level, class_2338 containerPos, class_2350 face, int amount, Predicate<class_3611> predicate) {
        class_2680 state = level.method_8320(containerPos);
        if (state.method_26204() instanceof FluidPipeBlock || pipe.totalAmount() >= 1000) {
            return false;
        }
        Storage fluidHandler = (Storage)FluidStorage.SIDED.find((class_1937)level, containerPos, (Object)face);
        if (fluidHandler != null && fluidHandler.supportsExtraction()) {
            long extracted = 0L;
            try (Transaction transaction = Transaction.openOuter();){
                FluidVariant fluidVariant;
                long amountToExtract = (long)Math.min(amount, pipe.remainingCapacity()) * 81L;
                if (predicate.test(pipe.getFluid()) && !(fluidVariant = FluidVariant.of((class_3611)pipe.getFluid())).isBlank()) {
                    extracted = fluidHandler.extract((Object)FluidVariant.of((class_3611)pipe.getFluid()), amountToExtract, (TransactionContext)transaction);
                }
                if (extracted <= 0L && pipe.isEmpty()) {
                    Iterator iterator = fluidHandler.nonEmptyIterator();
                    while (iterator.hasNext()) {
                        StorageView fluidStorage = (StorageView)iterator.next();
                        if (!predicate.test(((FluidVariant)fluidStorage.getResource()).getFluid()) || (extracted = fluidHandler.extract((Object)((FluidVariant)fluidStorage.getResource()), amountToExtract, (TransactionContext)transaction)) <= 0L) continue;
                        pipe.setFluid(((FluidVariant)fluidStorage.getResource()).getFluid());
                        break;
                    }
                }
                if (extracted > 0L) {
                    transaction.commit();
                }
            }
            if (extracted > 0L) {
                pipe.insertFluidPacket((class_1937)level, new FluidInPipe((int)(extracted / 81L), pipe.getTargetSpeed(), 0, face.method_10153(), face.method_10153(), 0));
                return true;
            }
        }
        return false;
    }

    @Override
    public FluidRenderInfo getFluidRenderInfo(class_3610 fluidState, class_1920 level, class_2338 pos) {
        FluidVariant fluidVariant = FluidVariant.of((class_3611)fluidState.method_15772());
        int tint = FluidVariantRendering.getColor((FluidVariant)fluidVariant, (class_1920)level, (class_2338)pos);
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        return new FluidRenderInfo(tint, sprite);
    }

    @Override
    public FluidRenderInfo getFluidRenderInfo(class_3610 fluidState) {
        FluidVariant fluidVariant = FluidVariant.of((class_3611)fluidState.method_15772());
        int tint = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        return new FluidRenderInfo(tint, sprite);
    }

    @Override
    public class_3611 getFluidFromStack(class_1799 stack) {
        class_3611 fluid = null;
        Storage fluidHandler = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        if (fluidHandler != null) {
            Iterator iterator = fluidHandler.nonEmptyIterator();
            if (iterator.hasNext()) {
                fluid = ((FluidVariant)((StorageView)iterator.next()).getResource()).getFluid();
            }
        } else {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1755) {
                class_1755 bucket = (class_1755)class_17922;
                fluid = bucket.field_7905;
            }
        }
        return fluid != null && fluid.method_15780(class_3612.field_15906) ? null : fluid;
    }

    @Override
    public class_2561 getFluidName(class_3611 fluid) {
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    @Override
    public class_2357 getDispenserBehaviour(class_1799 stack) {
        return (class_2357)class_2315.field_10919.get(stack.method_7909());
    }
}

